/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************
 * File:	generator.h						*
 *									*
 * Description:	This file contains the type and function declarations 	*
 *		which relate to the generator instance.			*
 *									*
 * History:	V1.0 by Jason Gobat and Darren C. Atkinson		*
 ************************************************************************/

# ifndef _GENERATOR_H
# define _GENERATOR_H
# include "mesh.h"

typedef struct {
    char    *title;			/* title of generator		*/
    Line    *lines;			/* array of lines		*/
    Grid    *grids;			/* array of grids		*/
    TriMesh *tris;			/* array of trianglular meshes	*/
    unsigned numlines;			/* number of nodes		*/
    unsigned numgrids;			/* number of elements		*/
    unsigned numtrimeshes;		/* number of tri-meshes		*/
    unsigned line;			/* current line number		*/
    unsigned numerrors;			/* number of errors		*/
} Generator;

extern Generator generator;


# if defined (__STDC__) || defined (__GNUC__)

extern int        yyparse         (void);
extern int        yylex           (void);
extern void       yyerror         (char *);
extern void       RestartLexer    (FILE *);
extern void       DestroyGenerator  (void);
extern int        GetGenerator      (FILE *, Line **, Grid **, TriMesh **,
                                     unsigned *, unsigned *, unsigned *);

# else

extern int        yyparse         ( );
extern int        yylex           ( );
extern void       yyerror         ( );
extern void       RestartLexer    ( );
extern void       DestroyGenerator  ( );
extern int        GetGenerator      ( );

# endif

# endif /* _GENERATOR_H */
