/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************
 * File:	generator.c						*
 *									*
 * Description:	This file contains the function definitions which	*
 * 		relate to the generator instance.			*
 ************************************************************************/	

# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include "mesh.h"
# include "generator.h"
# include "allocate.h"

Generator generator;


/************************************************************************
 * Function:	 GetGenerator						*
 *									*
 * Parameters:	 input	  - input file pointer				*
 *		 element  - pointer to an array of elements		*
 *		 node     - pointer to an array of nodes		*
 *		 numelts  - number of elements				*
 *		 numnodes - number of nodes				*
 *		 title	  - title of generator				*
 *									*
 * Return value: none							*
 *									*
 * Calls:	 yyparse						*
 *									*
 * Called by:	 main							*
 *									*
 * Global data:	 the generator instance is used				*
 *									*
 * Description:	 GetGenerator called by main to retrieve the generator	*
 *		 from the input file and returns the generator instance	*
 *		 as arrays of element and node structures.		*
 ************************************************************************/

int GetGenerator (input, lines, grids, tris, numline, numgrid, numtri)
    FILE     *input;
    Line     **lines;
    Grid     **grids;
    TriMesh  **tris;
    unsigned *numline,
             *numgrid,
             *numtri;
{
    RestartLexer (input);
    if (yyparse ( ))
	return 1;

    *lines = generator.lines;
    *grids = generator.grids;
    *tris  = generator.tris;
    *numgrid = generator.numgrids;
    *numline = generator.numlines;
    *numtri  = generator.numtrimeshes;

    return 0;
}
